
<div class="bg-white dark:bg-zinc-900 shadow rounded-lg">
    <div class="mt-4">
        {{ $projects->links() }}
    </div>
    <div class="bg-white dark:bg-zinc-900 shadow rounded-lg overflow-x-auto">
        <table class="min-w-[600px] w-full text-sm table-auto">
            <thead class="bg-zinc-100 dark:bg-zinc-800">
                <tr>
                    @foreach($columns as $col)
                    @access('project.index',$col['permission'])
                      <th class="px-4 py-2 text-start whitespace-nowrap">
                        {{ __($col['label']) }}
                      </th>
                    @endaccess
                  @endforeach
                    <th class="px-4 py-2 text-start whitespace-nowrap">
                        <select wire:model.live="perPage"
                            class="w-full rounded-lg bg-white dark:bg-zinc-800 border border-zinc-300 dark:border-zinc-700 text-sm px-3 py-2">
                            <option value="5">5</option>
                            <option value="10">10</option>
                            <option value="25">25</option>
                            <option value="50">50</option>
                        </select>
                    </th>
                </tr>
            </thead>
            <tbody>
                @foreach ($projects as $project)
                    <tr class="border-t dark:border-zinc-700">
                        @foreach($columns as $col)
                        @access('project.index',$col['permission'])
                          <td class="px-4 py-2 whitespace-nowrap">
                            @if($col['field']==='manager')
                            {{ $project->manager && is_array($project->manager->full_name)
                                            ? $project->manager->full_name[app()->getLocale()] ?? reset($project->manager->full_name)
                                            : '-' }}
                            @else
                              {{ $project->{$col['field']} }}
                            @endif
                          </td>
                        @endaccess
                      @endforeach
                        <td class="px-4 py-2 whitespace-nowrap text-end space-x-2">
                            @access('project.index','project.actions.edit')
                            <button wire:click="editProject({{ $project->id }})"
                                class="text-xs bg-yellow-500 hover:bg-yellow-600 text-white px-3 py-1 rounded shadow">
                                {{ __('backend.edit') }}
                            </button>
                            @endaccess
                            @access('project.index','project.actions.delete')
                            <button wire:click="confirmDeleteProject({{ $project->id }})"
                                class="text-xs bg-red-600 hover:bg-red-700 text-white px-3 py-1 rounded shadow">
                                {{ __('backend.delete') }}
                            </button>
                            @endaccess
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>


</div>
